/**
 * 
 */
package gov.va.med.mhv.usermgmt.main.registry;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public abstract class ModelObject {

    /**
     * Null-safe determination of hasCode of an object
     * @param value The object to get the hashcode for
     * @return The hashcode of value, 0 if the value is null
     */
    protected static int hashCodeOrZero(Object value) {
        return (value != null) ? value.hashCode() : 0;
    }

    /**
     * Null-safe equality comparison of objects.
     * @param value Value to compare
     * @param otherValue The other value to compare it to
     * @return True, if both objects are null or the objects are equal as 
     * indicated by the equals() method; false otherwise.
     */
    protected static boolean areEqual(Object value, Object otherValue) {
        return ((value == null) && (otherValue == null))
            || ((value != null) && value.equals(otherValue));
    }

    /**
     * Calculates a hash code from the hash codes of set of objects.
     * Note that an object does not need to provide all fields to calculate
     * a hashCode. Just use fields that will most likely be discriminating,
     * such that different value for these fields leads to different hash codes.
     * Using 2-3 fields probably sufficient.     
     * @param fields The fields used to calculate the hash code
     * @return The calculated hash code value
     */
    protected static int hashCode(Object[] fields) {
        final int PRIME = 31;
        int hashCode = 1;
        // TODO: This code could overflow the maximum integer,
        // as the result can grow quickly, if any of the fields 
        // hashcodes are big.
        if (fields != null) {
            for (Object field: fields) {
                hashCode = PRIME * hashCode + hashCodeOrZero(field);
            }
        }
        return hashCode;

    }

}
